// OpenLine4 demoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "OpenLine4 demo.h"
#include "OpenLine4 demoDlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

const DWORD WM_BTNFLASH = WM_USER + 1;
const DWORD WM_SELLINE = WM_USER + 2;
//-------------------------// 
/*
// unsolicited events (maskable)

#define VPB_RING		0
#define VPB_DIGIT		1
#define	VPB_TONEDETECT		2
#define	VPB_TIMEREXP		3
#define	VPB_VOXON		4
#define	VPB_VOXOFF		5
#define	VPB_PLAY_UNDERFLOW	6
#define	VPB_RECORD_OVERFLOW	7
#define VPB_DTMF		8
#define VPB_STATION_OFFHOOK	9
#define VPB_STATION_ONHOOK	10
#define VPB_RING_OFF		11
#define VPB_DROP		12
#define VPB_STATION_FLASH	13

// solicited events (not maskable)

#define	VPB_PLAYEND		100
#define	VPB_RECORDEND		101
#define	VPB_DIALEND		102
#define	VPB_TONE_DEBUG_END	103
#define	VPB_CALLEND		104

*/
static CString sLogText = "";

void WINAPI enable_wav_controls(bool bRec, bool bPlay, bool bStop)
{
	CWinApp* pApp = AfxGetApp();
	CWnd* pWnd = pApp->GetMainWnd();
	CButton* pBtnRec = (CButton*)pWnd->GetDlgItem(IDC_RECORD);
	pBtnRec->EnableWindow(bRec);

	CButton* pBtnPlay = (CButton*)pWnd->GetDlgItem(IDC_PLAY);
	pBtnPlay->EnableWindow(bPlay);
	
	CButton* pBtnStop = (CButton*)pWnd->GetDlgItem(IDC_STOP);
	pBtnStop->EnableWindow(bStop);
}

void WINAPI vpb_event_callback(VPB_EVENT *e, void *context)
{
	// Event callback
	CString sMsg;
	char szEvent[255];

	vpb_translate_event(e,szEvent);	
	
	szEvent[strlen(szEvent)-1] = 0;

	sMsg.Format("ch# %d:%s", e->handle+1,szEvent);
	//dlg->LogIt(sMsg);
	CWinApp* pApp = AfxGetApp();
	CWnd* pWnd = pApp->GetMainWnd();
	CEdit* pLog = (CEdit*)pWnd->GetDlgItem(IDC_LOG_EVENT);

	//pLog->GetWindowText(sLogText);
	sLogText = sLogText + sMsg +"\r\n";
	pLog->SetWindowText((LPCTSTR)(sLogText)) ;

	// Scroll to the end of the window
	pLog->SetSel(pLog->GetWindowTextLength()-1,pLog->GetWindowTextLength());
	// pLog->LineScroll(64000); 


	// Handle ring detection here

	int m_IDC = 0;
	int m_IDC_btn = 0;

	switch (e->handle)
	{
	case 0: m_IDC = IDC_RING_1; break;
	case 1: m_IDC = IDC_RING_2; break;
	case 2: m_IDC = IDC_RING_3; break;
	case 3: m_IDC = IDC_RING_4; break;
	}
	

	CStatic* pLed = (CStatic*)pWnd->GetDlgItem(m_IDC);
	
	switch (e->type)
	{
	case VPB_RING: 
		{
			pLed->SetBitmap (::LoadBitmap(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_GREEN)));
			break;
		}
	case VPB_RING_OFF: 
		{
			pLed->SetBitmap (::LoadBitmap(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_GRAY)));
			break;
		}
	case VPB_RECORDEND:
	case VPB_PLAYEND:
		{
			//enable_wav_controls(TRUE,TRUE,FALSE);
			pWnd->PostMessage (WM_SELLINE, 0, 0);

			break;
		}
	case VPB_DTMF:
		{
			// DTMF is detected -- light on buttons
			switch ((char)e->data)
			{
			case '0': m_IDC_btn = IDC_KEYPAD_0;break;
			case '1': m_IDC_btn = IDC_KEYPAD_1;break;
			case '2': m_IDC_btn = IDC_KEYPAD_2;break;
			case '3': m_IDC_btn = IDC_KEYPAD_3;break;
			case '4': m_IDC_btn = IDC_KEYPAD_4;break;
			case '5': m_IDC_btn = IDC_KEYPAD_5;break;
			case '6': m_IDC_btn = IDC_KEYPAD_6;break;
			case '7': m_IDC_btn = IDC_KEYPAD_7;break;
			case '8': m_IDC_btn = IDC_KEYPAD_8;break;
			case '9': m_IDC_btn = IDC_KEYPAD_9;break;
			case '*': m_IDC_btn = IDC_KEYPAD_STAR;break;
			case '#': m_IDC_btn = IDC_KEYPAD_SHARP;break;

			}

			//CButton* pBtn = (CButton*)pWnd->GetDlgItem(m_IDC_btn);
			if (m_IDC_btn)
				pWnd->PostMessage (WM_BTNFLASH, (WPARAM) m_IDC_btn, 0);
			break;
		}
	}

	//pLog->S
}


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COpenLine4demoDlg dialog

COpenLine4demoDlg::COpenLine4demoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COpenLine4demoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COpenLine4demoDlg)
	m_Log = _T("");
	m_PhoneNumber = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void COpenLine4demoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COpenLine4demoDlg)
	DDX_Text(pDX, IDC_LOG, m_Log);
	DDV_MaxChars(pDX, m_Log, 64000);
	DDX_Text(pDX, IDC_NUMBER, m_PhoneNumber);
	DDV_MaxChars(pDX, m_PhoneNumber, 20);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(COpenLine4demoDlg, CDialog)
	//{{AFX_MSG_MAP(COpenLine4demoDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_KEYPAD_0, OnKeypad)
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	ON_BN_CLICKED(IDC_RADIO_1, OnSelectLine)
	ON_BN_CLICKED(IDC_HOOK, OnHookSwitch)
	ON_WM_CLOSE()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_DIAL, OnDial)
	ON_BN_CLICKED(IDC_RECORD, OnRecord)
	ON_BN_CLICKED(IDC_PLAY, OnPlay)
	ON_BN_CLICKED(IDC_STOP, OnStop)
	ON_BN_CLICKED(IDC_KEYPAD_1, OnKeypad)
	ON_BN_CLICKED(IDC_KEYPAD_2, OnKeypad)
	ON_BN_CLICKED(IDC_KEYPAD_3, OnKeypad)
	ON_BN_CLICKED(IDC_KEYPAD_4, OnKeypad)
	ON_BN_CLICKED(IDC_KEYPAD_5, OnKeypad)
	ON_BN_CLICKED(IDC_KEYPAD_6, OnKeypad)
	ON_BN_CLICKED(IDC_KEYPAD_7, OnKeypad)
	ON_BN_CLICKED(IDC_KEYPAD_8, OnKeypad)
	ON_BN_CLICKED(IDC_KEYPAD_9, OnKeypad)
	ON_BN_CLICKED(IDC_KEYPAD_SHARP, OnKeypad)
	ON_BN_CLICKED(IDC_KEYPAD_STAR, OnKeypad)
	ON_BN_CLICKED(IDC_RADIO_2, OnSelectLine)
	ON_BN_CLICKED(IDC_RADIO_3, OnSelectLine)
	ON_BN_CLICKED(IDC_RADIO_4, OnSelectLine)
	ON_BN_CLICKED(IDC_KEYPAD_CLEAR, OnKeypad)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COpenLine4demoDlg message handlers

BOOL COpenLine4demoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// Check the first radio
	CButton* pRadio = (CButton*)GetDlgItem(IDC_RADIO_1);
	pRadio->SetCheck(TRUE);
	m_CardIndex = 0;

	CEdit* pEdit = (CEdit*)GetDlgItem(IDC_FILENAME);
	pEdit->SetWindowText("test.wav"); 

	// Add to log
	LogIt("Application started");
	
	
	for (int i=0; i<4; i++)
	{
		m_pOpenCard[i] = NULL;
		m_pOpenCard[i] = new COpenLine4();
		if (!m_pOpenCard[i]->InitVPB(1,i+1)) 
		{	
			CString sErr;
			
			sErr.Format("Error opening channel %d. Error # %d",i+1,m_pOpenCard[i]->GetLastError());
			LogIt(sErr);
			
		}
		else
		{
			m_pOpenCard[i]->SetCallback(&vpb_event_callback, NULL);
		}
	}
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void COpenLine4demoDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void COpenLine4demoDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR COpenLine4demoDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void COpenLine4demoDlg::OnKeypad() 
{
	// Get edit control
	CEdit* pEdit = (CEdit*)GetDlgItem(IDC_NUMBER);
	CString sNum;
	pEdit->GetWindowText(sNum); 
	// Get window having focus
	CWnd* currWin = GetFocus ();
	
	if (currWin == GetDlgItem(IDC_KEYPAD_0))
	{
		sNum+="0";
	}
	else if (currWin == GetDlgItem(IDC_KEYPAD_1))
	{
		sNum+="1";
	}
	else if (currWin == GetDlgItem(IDC_KEYPAD_2))
	{
		sNum+="2";
	}
	else if (currWin == GetDlgItem(IDC_KEYPAD_3))
	{
		sNum+="3";
	}
	else if (currWin == GetDlgItem(IDC_KEYPAD_4))
	{
		sNum+="4";
	}
	else if (currWin == GetDlgItem(IDC_KEYPAD_5))
	{
		sNum+="5";
	}
	else if (currWin == GetDlgItem(IDC_KEYPAD_6))
	{
		sNum+="6";
	}
	else if (currWin == GetDlgItem(IDC_KEYPAD_7))
	{
		sNum+="7";
	}
	else if (currWin == GetDlgItem(IDC_KEYPAD_8))
	{
		sNum+="8";
	}
	else if (currWin == GetDlgItem(IDC_KEYPAD_9))
	{
		sNum+="9";
	}
	else if (currWin == GetDlgItem(IDC_KEYPAD_SHARP))
	{
		sNum+="#";
	}
	else if (currWin == GetDlgItem(IDC_KEYPAD_STAR))
	{
		sNum+="*";
	} 
	else if (currWin == GetDlgItem(IDC_KEYPAD_CLEAR))
	{
		sNum="";
	} 

	
	pEdit->SetWindowText((LPCTSTR)sNum ); 
	
}

void COpenLine4demoDlg::OnBrowse() 
{
	// TODO: Add your control notification handler code here
	CFileDialog dlgFile(TRUE);
	
	CString str("All files (*.*)"); str += (TCHAR)NULL;
	str+= "*.*"; str += (TCHAR)NULL;	
	str+= "WAV files (*.wav)";		str += (TCHAR)NULL;
	str+= "*.wav"; str += (TCHAR)NULL;

	dlgFile.m_ofn.lpstrFilter = str;
	dlgFile.m_ofn.nFilterIndex = 2;

	// Filename buffer 
	TCHAR strName[_MAX_PATH];
	strName[0] = (TCHAR)NULL;

	dlgFile.m_ofn.lpstrFile = strName;

	//Show dialog
	if (dlgFile.DoModal() == IDOK)
	{
		CEdit* pEdit = (CEdit*)GetDlgItem(IDC_FILENAME);
		pEdit->SetWindowText(dlgFile.m_ofn.lpstrFile);
	}
}


void COpenLine4demoDlg::LogIt(CString text)
{
	m_Log += (text + "\r\n");
	UpdateData(FALSE);
	CEdit* pLog = (CEdit*)GetDlgItem(IDC_LOG);
	//
	pLog->SetSel(pLog->GetWindowTextLength()-1,pLog->GetWindowTextLength());

}

void COpenLine4demoDlg::OnSelectLine() 
{
	// Select desired OpenLine4 line here
	// Get window having focus
	CWnd* currWin = GetFocus ();
	if (currWin == GetDlgItem(IDC_RADIO_1))
	{
		m_CardIndex = 0;
		LogIt("Ch#1 selected");
	}
	else if (currWin == GetDlgItem(IDC_RADIO_2))
	{
		m_CardIndex = 1;
		LogIt("Ch#2 selected");
	}
	else if (currWin == GetDlgItem(IDC_RADIO_3))
	{
		m_CardIndex = 2;
		LogIt("Ch#3 selected");
	}
	else if (currWin == GetDlgItem(IDC_RADIO_4))
	{
		m_CardIndex = 3;
		LogIt("Ch#4 selected");

	};

	// Enable/disable wav controls
	if (m_pOpenCard[m_CardIndex]->IsRecording() || m_pOpenCard[m_CardIndex]->IsPlaying())
	{
		enable_wav_controls(FALSE,FALSE,TRUE);
	}
	else
	{
		enable_wav_controls(TRUE,TRUE,FALSE);
	}

}

void COpenLine4demoDlg::OnHookSwitch() 
{
	// Switch hook state
	int m_IDC;

	switch (m_CardIndex)
	{
	case 0: m_IDC = IDC_ONLINE_1; break;
	case 1: m_IDC = IDC_ONLINE_2; break;
	case 2: m_IDC = IDC_ONLINE_3; break;
	case 3: m_IDC = IDC_ONLINE_4; break;
	}
	
	m_pOpenCard[m_CardIndex]->SwitchHook();

	CStatic* pLed = (CStatic*)GetDlgItem(m_IDC);
	
	if (m_pOpenCard[m_CardIndex]->GetHookState())
	{
		pLed->SetBitmap (::LoadBitmap(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_GREEN)));
	}
	else
	{
		pLed->SetBitmap (::LoadBitmap(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_GRAY)));
	}
	
}

void COpenLine4demoDlg::OnClose() 
{

	CDialog::OnClose();
}

void COpenLine4demoDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	// Delete OpenLine4 objects
	for (int i=0; i<4; i++) 
		if (m_pOpenCard[i]) 
		{
			m_pOpenCard[i]->ShutDownVPB();
			delete m_pOpenCard[i];
			m_pOpenCard[i] = NULL;
		}
			
}

void COpenLine4demoDlg::OnDial() 
{
	// Get edit control
	CEdit* pEdit = (CEdit*)GetDlgItem(IDC_NUMBER);
	CString sNum;
	// Get number to dial
	pEdit->GetWindowText(sNum); 

	if (m_pOpenCard[m_CardIndex])
	{
		if (!m_pOpenCard[m_CardIndex]->Call (sNum)) 
		{
			CString sErr;
			
			sErr.Format("Error calling on channel %d. Error # %d",
				m_CardIndex + 1,m_pOpenCard[m_CardIndex]->GetLastError());
			LogIt(sErr);
		};
	}
	
}

void COpenLine4demoDlg::OnRecord() 
{

	// Get edit control
	CEdit* pEdit = (CEdit*)GetDlgItem(IDC_FILENAME);
	CString sFileName;
	pEdit->GetWindowText(sFileName);

	if (m_pOpenCard[m_CardIndex])
	{
		if (!m_pOpenCard[m_CardIndex]->RecordFile(sFileName) )
		{
			CString sErr;
			
			sErr.Format("Error recording on channel %d. Error # %d",
				m_CardIndex + 1, m_pOpenCard[m_CardIndex]->GetLastError());
			LogIt(sErr);
		}
		else
		{
			CString sMsg;

			sMsg.Format("Start recording on channel %d.", m_CardIndex + 1);
			LogIt(sMsg);	
			enable_wav_controls(FALSE,FALSE,TRUE);
		};
	}
}

void COpenLine4demoDlg::OnPlay() 
{
	// Get edit control
	CEdit* pEdit = (CEdit*)GetDlgItem(IDC_FILENAME);
	CString sFileName;
	pEdit->GetWindowText(sFileName);

	if (m_pOpenCard[m_CardIndex])
	{
		if (!m_pOpenCard[m_CardIndex]->PlayFile(sFileName) ) 
		{
			CString sErr;
			
			sErr.Format("Error playing file on channel %d. Error # %d",
				m_CardIndex + 1, m_pOpenCard[m_CardIndex]->GetLastError());
			LogIt(sErr);
		}
		else
		{
			enable_wav_controls(FALSE,FALSE,TRUE);
		};
	}
	
}

void COpenLine4demoDlg::OnStop() 
{

	if (m_pOpenCard[m_CardIndex])
	{
		CString sMsg;

		if (m_pOpenCard[m_CardIndex]->StopRecord())
			sMsg.Format("Stop recording on channel %d.",	m_CardIndex + 1);
		
		m_pOpenCard[m_CardIndex]->StopPlay();


		LogIt(sMsg);

		enable_wav_controls(TRUE,TRUE,FALSE);
	}
	
}


BOOL COpenLine4demoDlg::OnBtnFlash (DWORD dwId)
{
	if (!dwId)
		return FALSE;

	RECT rcBtn;
	CButton *pBtn = (CButton *) GetDlgItem(dwId);
	pBtn->GetWindowRect (&rcBtn);
	TRACE ("[%d %d %d %d]\n", rcBtn.left,rcBtn.top,rcBtn.right, rcBtn.bottom);
	HDC hDsk = ::GetDC (HWND_DESKTOP);
	::InvertRect (hDsk, &rcBtn);
	::ReleaseDC (HWND_DESKTOP, hDsk);
	Sleep (200);
	hDsk = ::GetDC (HWND_DESKTOP);
	::InvertRect (hDsk, &rcBtn);
	::ReleaseDC (HWND_DESKTOP, hDsk);

	return TRUE;
}

BOOL COpenLine4demoDlg::PreTranslateMessage(MSG* pMsg) 
{
	if (pMsg->message == WM_BTNFLASH)
	{
		OnBtnFlash (pMsg->wParam);
		return TRUE;
	}

	if (pMsg->message == WM_SELLINE)
	{
		OnSelectLine() ;
		return TRUE;
	}
	
	return CDialog::PreTranslateMessage(pMsg);
}
